/*
 * Decompiled with CFR 0.152.
 */
package moneyview.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import moneyview.data.AItem;
import moneyview.data.APlannedItem;
import moneyview.data.Account;
import moneyview.data.Util;
import moneyview.gui.Constants;
import moneyview.gui.GuiUtil;
import moneyview.gui.IKeyboardListener;
import moneyview.gui.MainWindow;
import moneyview.gui.custom.AutoCompleteTextField;
import moneyview.gui.custom.DateChooser;
import moneyview.gui.custom.KeyboardMainListener;
import moneyview.messages.Messages;

public class NewPlannedOperationDialog
extends JDialog
implements IKeyboardListener {
    private JTextField textFieldDate;
    private AutoCompleteTextField textFieldPayee;
    private AutoCompleteTextField textFieldMemo;
    private JTextField textFieldAmount;
    private JComboBox<String> comboBoxCategory;
    private JComboBox<String> accountComboBox;
    private JComboBox<String> periodComboBox;
    JRadioButton rdbtnDebit;
    public boolean okSelected = false;
    APlannedItem aPlannedItem = null;
    AItem baseAItem;
    String baseItemAccountName;

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            KeyboardMainListener.addCurrentListener(this);
            final NewPlannedOperationDialog thisNewOperationDialog = this;
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    KeyboardMainListener.removeListener(thisNewOperationDialog);
                }
            });
        }
        super.setVisible(visible);
    }

    @Override
    public void escapeKeyTyped() {
        this.dispose();
    }

    @Override
    public void enterKeyTyped() {
    }

    @Override
    public void deleteKeyTyped() {
    }

    public NewPlannedOperationDialog(JFrame frame, String title, boolean modal) {
        this(frame, title, modal, null, null);
    }

    public NewPlannedOperationDialog(JFrame frame, String title, boolean modal, AItem baseAItem, String baseItemAccountName) {
        super(frame, title, modal);
        this.setResizable(false);
        this.setSize(579, 509);
        this.setLocation(frame.getX() + 300, frame.getY() + 300);
        this.getContentPane().setLayout(null);
        this.baseAItem = baseAItem;
        this.baseItemAccountName = baseItemAccountName;
        JLabel lblDate = new JLabel(Messages.getString("NewPlannedOperationDialog.0"));
        lblDate.setFont(Constants.tahomaBold12Font);
        lblDate.setBounds(335, 166, 134, 20);
        this.getContentPane().add(lblDate);
        this.periodComboBox = new JComboBox();
        this.periodComboBox.setBounds(10, 111, 427, 27);
        for (int i = 1; i <= 9; ++i) {
            this.periodComboBox.addItem(APlannedItem.getPeriodicityLabel(i));
        }
        this.getContentPane().add(this.periodComboBox);
        this.periodComboBox.setSelectedIndex(3);
        this.textFieldDate = new JTextField();
        GregorianCalendar l_gc = new GregorianCalendar();
        l_gc.setTime(baseAItem != null ? baseAItem.getDate() : new Date());
        l_gc.add(2, 1);
        this.textFieldDate.setText(Util.getSimpleDateFormatter().format(l_gc.getTime()));
        this.textFieldDate.setColumns(10);
        this.textFieldDate.setBounds(335, 188, 165, 27);
        this.getContentPane().add(this.textFieldDate);
        JLabel lblDdmmyyyy = new JLabel(Util.getDateUserInputTemplate());
        lblDdmmyyyy.setBounds(338, 218, 180, 16);
        this.getContentPane().add(lblDdmmyyyy);
        JLabel lblNum = new JLabel(Messages.getString("NewPlannedOperationDialog.1"));
        lblNum.setFont(Constants.tahomaBold12Font);
        lblNum.setBounds(10, 86, 158, 14);
        this.getContentPane().add(lblNum);
        JLabel lblPayee = new JLabel(Messages.getString("NewPlannedOperationDialog.2"));
        lblPayee.setBounds(10, 251, 46, 14);
        this.getContentPane().add(lblPayee);
        this.textFieldPayee = new AutoCompleteTextField();
        this.textFieldPayee.setBounds(10, 267, 546, 27);
        this.getContentPane().add(this.textFieldPayee);
        if (baseAItem != null && baseAItem.getPayee() != null) {
            this.textFieldPayee.setText(baseAItem.getPayee());
        }
        this.textFieldPayee.setColumns(10);
        JLabel lblCategory = new JLabel(Messages.getString("NewPlannedOperationDialog.3"));
        lblCategory.setBounds(10, 305, 210, 14);
        this.getContentPane().add(lblCategory);
        this.comboBoxCategory = GuiUtil.getCategoriesComboBox(null);
        this.comboBoxCategory.setBounds(9, 323, 490, 27);
        if (baseAItem != null && baseAItem.getCategory() != null) {
            this.comboBoxCategory.setSelectedItem(Util.getUserFriendlyCategoryString(baseAItem.getCategory()));
        }
        this.getContentPane().add(this.comboBoxCategory);
        JLabel lblMemo = new JLabel(Messages.getString("NewPlannedOperationDialog.4"));
        lblMemo.setBounds(10, 361, 195, 14);
        this.getContentPane().add(lblMemo);
        this.textFieldMemo = new AutoCompleteTextField();
        this.textFieldMemo.setBounds(10, 379, 546, 27);
        if (baseAItem != null && baseAItem.getMemo() != null) {
            this.textFieldMemo.setText(baseAItem.getMemo());
        }
        this.getContentPane().add(this.textFieldMemo);
        this.textFieldMemo.setColumns(10);
        JLabel lblMontant = new JLabel(Messages.getString("NewPlannedOperationDialog.5"));
        lblMontant.setFont(Constants.tahomaBold12Font);
        lblMontant.setBounds(129, 172, 180, 14);
        this.getContentPane().add(lblMontant);
        this.textFieldAmount = new JTextField();
        this.textFieldAmount.setBounds(129, 188, 165, 27);
        if (baseAItem != null) {
            this.textFieldAmount.setText(baseAItem.getAmountString().startsWith("-") ? baseAItem.getAmountString().substring(1) : baseAItem.getAmountString());
        }
        this.getContentPane().add(this.textFieldAmount);
        this.textFieldAmount.setColumns(10);
        JButton btnCancel = new JButton(Messages.getString("NewPlannedOperationDialog.7"));
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewPlannedOperationDialog.this.dispose();
            }
        });
        btnCancel.setBounds(96, 431, 143, 39);
        this.getContentPane().add(btnCancel);
        JButton btnOk = new JButton(Messages.getString("NewPlannedOperationDialog.8"));
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Account.openAccounts.isEmpty()) {
                    JOptionPane.showMessageDialog(NewPlannedOperationDialog.this.getContentPane(), Messages.getString("NewPlannedOperationDialog.10"), Messages.getString("WINDOW_TITLE_INFO"), 1);
                    return;
                }
                NewPlannedOperationDialog.this.aPlannedItem = new APlannedItem();
                if (NewPlannedOperationDialog.this.textFieldPayee.getText().length() > 0) {
                    NewPlannedOperationDialog.this.aPlannedItem.setPayee(NewPlannedOperationDialog.this.textFieldPayee.getText());
                }
                if (NewPlannedOperationDialog.this.textFieldMemo.getText().length() > 0) {
                    NewPlannedOperationDialog.this.aPlannedItem.setMemo(NewPlannedOperationDialog.this.textFieldMemo.getText());
                }
                NewPlannedOperationDialog.this.aPlannedItem.setAccountName(NewPlannedOperationDialog.this.accountComboBox.getSelectedItem().toString());
                NewPlannedOperationDialog.this.aPlannedItem.setPeriodicity(APlannedItem.getPeriodicityFromLabel(NewPlannedOperationDialog.this.periodComboBox.getSelectedItem().toString()));
                try {
                    NewPlannedOperationDialog.this.aPlannedItem.setLongAmount(Util.parseAmount(NewPlannedOperationDialog.this.textFieldAmount.getText()));
                    if (NewPlannedOperationDialog.this.rdbtnDebit.isSelected()) {
                        NewPlannedOperationDialog.this.aPlannedItem.setLongAmount(-NewPlannedOperationDialog.this.aPlannedItem.getLongAmount());
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(NewPlannedOperationDialog.this.getContentPane(), Messages.getString("NewPlannedOperationDialog.9"), Messages.getString("WINDOW_TITLE_ERROR"), 0);
                    return;
                }
                try {
                    Date date = Util.parseDate(NewPlannedOperationDialog.this.textFieldDate.getText(), Util.getDateDayFirst());
                    NewPlannedOperationDialog.this.aPlannedItem.setDate(date);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(NewPlannedOperationDialog.this.getContentPane(), Messages.getString("NewPlannedOperationDialog.11"), Messages.getString("WINDOW_TITLE_ERROR"), 0);
                    NewPlannedOperationDialog.this.textFieldDate.setText(Util.getDateUserInputTemplate());
                    return;
                }
                if (NewPlannedOperationDialog.this.comboBoxCategory.getSelectedIndex() > -1) {
                    NewPlannedOperationDialog.this.aPlannedItem.setCategory(NewPlannedOperationDialog.this.comboBoxCategory.getSelectedItem().toString());
                }
                NewPlannedOperationDialog.this.okSelected = true;
                NewPlannedOperationDialog.this.dispose();
            }
        });
        btnOk.setBounds(334, 431, 143, 39);
        this.getContentPane().add(btnOk);
        ButtonGroup l_bg = new ButtonGroup();
        JRadioButton rdbtnCredit = new JRadioButton(Messages.getString("NewPlannedOperationDialog.13"));
        rdbtnCredit.setForeground(Constants.darkGreenColor);
        l_bg.add(rdbtnCredit);
        rdbtnCredit.setFont(Constants.tahomaBold12Font);
        rdbtnCredit.setBounds(19, 172, 83, 23);
        this.getContentPane().add(rdbtnCredit);
        this.rdbtnDebit = new JRadioButton(Messages.getString("NewPlannedOperationDialog.14"));
        this.rdbtnDebit.setForeground(Constants.darkRedColor);
        l_bg.add(this.rdbtnDebit);
        this.rdbtnDebit.setFont(Constants.tahomaBold12Font);
        this.rdbtnDebit.setBounds(20, 198, 82, 23);
        this.getContentPane().add(this.rdbtnDebit);
        if (baseAItem != null && baseAItem.isNegativeAmount()) {
            rdbtnCredit.setSelected(false);
            this.rdbtnDebit.setSelected(true);
        } else {
            rdbtnCredit.setSelected(true);
            this.rdbtnDebit.setSelected(false);
        }
        JButton l_dateButton = GuiUtil.getChooseDateButton(36, 27);
        l_dateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Date l_inDate = new Date();
                try {
                    l_inDate = Util.parseDate(NewPlannedOperationDialog.this.textFieldDate.getText(), Util.getDateDayFirst());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String l_chosenDate = new DateChooser(MainWindow.getFrame(), l_inDate).getPickedDate();
                if (l_chosenDate != null && l_chosenDate.length() > 0) {
                    NewPlannedOperationDialog.this.textFieldDate.setText(l_chosenDate);
                }
            }
        });
        l_dateButton.setBounds(500, 188, 36, 27);
        this.getContentPane().add(l_dateButton);
        JButton l_categoryButton = GuiUtil.getChooseCategoryButton(36, 27);
        l_categoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiUtil.getCategoryPopup(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String l_cat = GuiUtil.getCategoryChosenInCategoryPopup(e);
                        NewPlannedOperationDialog.this.comboBoxCategory.setSelectedItem(l_cat);
                    }
                }, null).show((Component)e.getSource(), 0, 0);
            }
        });
        l_categoryButton.setBounds(500, 323, 36, 27);
        this.getContentPane().add(l_categoryButton);
        JLabel lblAccount = new JLabel(Messages.getString("NewPlannedOperationDialog.15"));
        lblAccount.setFont(Constants.tahomaBold12Font);
        lblAccount.setBounds(10, 21, 180, 20);
        this.getContentPane().add(lblAccount);
        this.accountComboBox = new JComboBox();
        this.accountComboBox.setBounds(10, 48, 427, 27);
        this.accountComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String l_accountName = (String)NewPlannedOperationDialog.this.accountComboBox.getSelectedItem();
                NewPlannedOperationDialog.this.textFieldPayee.setKnowValues(Account.getAccountByName(l_accountName).getPayeeValues());
                NewPlannedOperationDialog.this.textFieldMemo.setKnowValues(Account.getAccountByName(l_accountName).getMemoValues());
            }
        });
        for (Account l_a : Account.openAccounts) {
            this.accountComboBox.addItem(l_a.accountName);
        }
        if (baseItemAccountName != null) {
            this.accountComboBox.setSelectedItem(baseItemAccountName);
        }
        this.getContentPane().add(this.accountComboBox);
    }
}

