/*
 * Decompiled with CFR 0.152.
 */
package moneyview.gui.custom;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import javax.swing.JTextField;

public class AutoCompleteTextField
extends JTextField {
    private Hashtable<String, Integer> knownValues = null;

    public AutoCompleteTextField() {
        this.addKeyListener(new AutoCompleteKeyListener());
    }

    public AutoCompleteTextField(Hashtable<String, Integer> knowValues) {
        this();
        this.setKnowValues(knowValues);
    }

    public void setKnowValues(Hashtable<String, Integer> ht) {
        this.knownValues = ht;
    }

    private void updateAutoComplete() {
        if (this.knownValues == null) {
            return;
        }
        String text = this.getText();
        int l_caretPos = this.getCaretPosition();
        String value = this.getAutoCompleteValue(text);
        if (value != null) {
            this.setText(value);
            this.setCaretPosition(l_caretPos);
            this.setSelectionStart(l_caretPos);
            this.setSelectionEnd(value.length());
        }
    }

    private String getAutoCompleteValue(String text) {
        String l_bestMatch = null;
        int l_bestScore = 0;
        for (String key : this.knownValues.keySet()) {
            if (!key.startsWith(text) || this.knownValues.get(key) <= l_bestScore) continue;
            l_bestMatch = key;
            l_bestScore = this.knownValues.get(l_bestMatch);
        }
        return l_bestMatch;
    }

    private class AutoCompleteKeyListener
    extends KeyAdapter {
        private AutoCompleteKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            int l_key = e.getKeyCode();
            if (l_key >= 65 && l_key <= 90 || l_key >= 97 && l_key <= 122 || l_key >= 48 && l_key <= 57) {
                AutoCompleteTextField.this.updateAutoComplete();
            }
        }
    }
}

