/*
 * Decompiled with CFR 0.152.
 */
package moneyview.gui.custom;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import moneyview.gui.IKeyboardListener;
import moneyview.gui.custom.KeyboardMainListener;

public class NewPasswordInputDialog
extends JDialog
implements IKeyboardListener {
    public String newPassword = null;
    private static final String TAG = NewPasswordInputDialog.class.getSimpleName();
    private JPasswordField passwordField;
    private JPasswordField passwordField2;

    public NewPasswordInputDialog(Frame frame) {
        super(frame);
        this.setResizable(false);
        this.setSize(310, 240);
        this.setLocation(frame.getX() + 300, frame.getY() + 300);
        this.setAlwaysOnTop(true);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("New password for file encryption");
        this.getContentPane().setLayout(null);
        JLabel lblPleaseEnterNew = new JLabel("Please enter new password");
        lblPleaseEnterNew.setBounds(10, 24, 241, 21);
        this.getContentPane().add(lblPleaseEnterNew);
        this.passwordField = new JPasswordField();
        this.passwordField.setBounds(10, 51, 281, 31);
        this.getContentPane().add(this.passwordField);
        JLabel lblPleaseEnterNew_1 = new JLabel("Please enter new password verification");
        lblPleaseEnterNew_1.setBounds(10, 93, 241, 21);
        this.getContentPane().add(lblPleaseEnterNew_1);
        this.passwordField2 = new JPasswordField();
        this.passwordField2.setBounds(10, 120, 281, 31);
        this.getContentPane().add(this.passwordField2);
        JButton btnOk = new JButton("OK");
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String passwd1 = String.valueOf(NewPasswordInputDialog.this.passwordField.getPassword());
                String passwd2 = String.valueOf(NewPasswordInputDialog.this.passwordField2.getPassword());
                if (passwd1 == null || passwd2 == null || passwd1.length() < 1 || passwd2.length() < 1 || !passwd1.equals(passwd2)) {
                    JOptionPane.showMessageDialog(NewPasswordInputDialog.this, "Invalid input (too short) or verification password differs.");
                    return;
                }
                NewPasswordInputDialog.this.newPassword = passwd1;
                NewPasswordInputDialog.this.dispose();
            }
        });
        btnOk.setBounds(181, 171, 89, 33);
        this.getContentPane().add(btnOk);
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NewPasswordInputDialog.this.newPassword = null;
                NewPasswordInputDialog.this.dispose();
            }
        });
        btnCancel.setBounds(46, 171, 89, 33);
        this.getContentPane().add(btnCancel);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            KeyboardMainListener.addCurrentListener(this);
            final NewPasswordInputDialog thisNewPasswordInput = this;
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    KeyboardMainListener.removeListener(thisNewPasswordInput);
                }
            });
        }
        super.setVisible(visible);
    }

    @Override
    public void escapeKeyTyped() {
        this.newPassword = null;
        this.dispose();
    }

    @Override
    public void enterKeyTyped() {
    }

    @Override
    public void deleteKeyTyped() {
    }
}

