/*
 * Decompiled with CFR 0.152.
 */
package moneyview.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import moneyview.Logger;
import moneyview.data.ACategory;
import moneyview.io.MoneyviewCipher;

public class IOUtil {
    private static final String TAG = ACategory.class.getSimpleName();
    public static boolean notUtf8FileFound = false;

    public static BufferedReader getBufferedReader(String fileName, String password) throws Exception {
        BufferedReader l_br = null;
        File l_utf8File = new File(fileName + "-utf8.data");
        if (l_utf8File.exists()) {
            fileName = fileName + "-utf8.data";
            Logger.debug(TAG, "getBufferedReader(" + fileName + ") - Changing to file: " + fileName);
            l_br = password != null ? new BufferedReader(new InputStreamReader(MoneyviewCipher.getInputStream(new FileInputStream(fileName), password), "UTF-8")) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8"));
            return l_br;
        }
        notUtf8FileFound = true;
        l_br = password != null ? new BufferedReader(new InputStreamReader(MoneyviewCipher.getInputStream(new FileInputStream(fileName), password), "ISO-8859-1")) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "ISO-8859-1"));
        return l_br;
    }

    public static BufferedWriter getBufferedWriter(String fileName, String password) throws Exception {
        BufferedWriter l_bw = null;
        fileName = fileName + "-utf8.data";
        Logger.debug(TAG, "getBufferedWriter(" + fileName + ") - Changing to file: " + fileName);
        l_bw = password != null ? new BufferedWriter(new OutputStreamWriter(MoneyviewCipher.getOutputStream(new FileOutputStream(fileName), password), "UTF-8")) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF-8"));
        return l_bw;
    }

    public static final String toUtf8(String str) {
        int l_index;
        String s = str;
        s = s.replace("\\\\", "\\");
        s = s.replace("\\:", ":");
        while ((l_index = s.indexOf("\\u")) != -1) {
            try {
                char l_c = (char)Integer.parseInt(s.substring(l_index + 2, l_index + 6), 16);
                s = s.substring(0, l_index) + l_c + s.substring(l_index + 6);
            }
            catch (Exception e) {
                Logger.error(TAG, "toUtf8(" + str + ") - Error at index=" + l_index + ", Exception=" + e.toString());
                break;
            }
        }
        return s;
    }

    public static final void writeUtf8Header(BufferedWriter bw, String comment) throws Exception {
        bw.write("## Do not remove or change this line - file encoding UTF-8 - ##\n");
        if (comment != null) {
            bw.write("## " + comment + "\n");
        }
        bw.write("## " + new Date().toString() + "\n");
    }
}

