/*
 * Decompiled with CFR 0.152.
 */
package moneyview.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Locale;
import moneyview.Logger;
import moneyview.io.IOUtil;
import moneyview.messages.Messages;

public class KvmStore {
    private static final String TAG = KvmStore.class.getSimpleName();
    private HashMap<String, String> kvm = new HashMap();
    private String loadedFileName = null;
    public boolean wasChangedToUtf8 = false;

    public String get(String key) {
        return this.kvm.get(key);
    }

    public String put(String key, String value) {
        return this.kvm.put(key, value);
    }

    public String remove(String key) {
        return this.kvm.remove(key);
    }

    public HashMap<String, String> getKvm() {
        return this.kvm;
    }

    public boolean loadMessages(Locale locale) {
        BufferedReader l_br = null;
        this.kvm.clear();
        String l_fn = "messages_" + locale + "-utf8.data";
        try {
            Logger.info(TAG, "loadMessages(" + l_fn + ")");
            InputStream l_is = Messages.class.getResourceAsStream(l_fn);
            l_br = new BufferedReader(new InputStreamReader(l_is, "UTF-8"));
            return this.parseFile(l_br, l_fn);
        }
        catch (Exception e) {
            Logger.error(TAG, "loadMessages(" + l_fn + ") - Exception=" + e.toString());
            return false;
        }
    }

    public boolean loadFile(String fileName) throws Exception {
        File l_f;
        BufferedReader l_br = null;
        String l_utf8File = this.utf8FileName(fileName);
        if (!l_utf8File.equals(fileName) && (l_f = new File(l_utf8File)).exists()) {
            fileName = l_utf8File;
        }
        this.loadedFileName = fileName;
        if (this.isUtf8File(fileName)) {
            Logger.info(TAG, "loadFile(" + fileName + ") in UTF-8");
            l_br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8"));
        } else {
            Logger.info(TAG, "loadFile(" + fileName + ") in ISO-8859-1");
            l_br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "ISO-8859-1"));
            this.wasChangedToUtf8 = true;
        }
        return this.parseFile(l_br, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseFile(BufferedReader br, String fileName) {
        try {
            boolean l_utf8 = false;
            int l_lineNumber = 0;
            while (true) {
                String l_line = br.readLine();
                ++l_lineNumber;
                if (l_line == null) break;
                if ((l_line = l_line.trim()).isEmpty()) continue;
                if (l_line.startsWith("#")) {
                    if (l_line.indexOf("UTF-8") <= -1) continue;
                    l_utf8 = true;
                    continue;
                }
                String l_k = "";
                String l_v = "";
                try {
                    int l_eqIndex = l_line.indexOf(61);
                    l_k = l_line.substring(0, l_eqIndex).trim();
                    l_v = l_line.substring(l_eqIndex + 1);
                    if (!l_utf8) {
                        l_k = IOUtil.toUtf8(l_k);
                        l_v = IOUtil.toUtf8(l_v);
                    }
                    this.kvm.put(l_k, l_v);
                }
                catch (Exception e) {
                    Logger.error(TAG, "parseFile(" + fileName + ") - Exception, line number=" + l_lineNumber + ", key='" + l_k + "', Exception=" + e.toString());
                    boolean bl = false;
                    try {
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (Exception e2) {
                        Logger.error(TAG, "parseFile(" + fileName + ") - Exception closing file=" + e2.toString());
                    }
                    return bl;
                }
            }
            boolean l_line = true;
            return l_line;
        }
        catch (Exception e) {
            Logger.error(TAG, "parseFile(" + fileName + ") - Exception=" + e.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception e) {
                Logger.error(TAG, "parseFile(" + fileName + ") - Exception closing file=" + e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUtf8File(String fileName) throws Exception {
        BufferedReader l_br = null;
        boolean l_utf8 = false;
        try {
            l_br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8"));
            for (int i = 0; i < 5; ++i) {
                String l_line = l_br.readLine();
                if (l_line == null) {
                } else {
                    if ((l_line = l_line.trim()).isEmpty() || !l_line.startsWith("#") || l_line.indexOf("UTF-8") <= -1) continue;
                    l_utf8 = true;
                }
                break;
            }
        }
        finally {
            try {
                if (l_br != null) {
                    l_br.close();
                }
            }
            catch (Exception e) {
                Logger.info(TAG, "isUtf8File(" + fileName + ") - Exception closing file=" + e.toString());
            }
        }
        Logger.debug(TAG, "isUtf8File(" + fileName + ") --> " + l_utf8);
        return l_utf8;
    }

    public String utf8FileName(String fileName) {
        if (fileName.endsWith("savedir.location")) {
            return fileName.substring(0, fileName.lastIndexOf("savedir.location")) + "savelocation-utf8.data";
        }
        if (fileName.endsWith(".properties")) {
            return fileName.substring(0, fileName.lastIndexOf(".properties")) + "-utf8.data";
        }
        return fileName;
    }

    public void saveToFile(String comment) {
        this.saveToFile(this.loadedFileName, comment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile(String fileName, String comment) {
        BufferedWriter l_bw = null;
        fileName = this.utf8FileName(fileName);
        try {
            Logger.info(TAG, "saveToFile( '" + fileName + "', '" + comment + "')");
            l_bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF-8"));
            IOUtil.writeUtf8Header(l_bw, comment);
            for (String l_k : this.kvm.keySet()) {
                l_bw.write(l_k + "=" + this.kvm.get(l_k) + "\n");
            }
        }
        catch (Exception e) {
            Logger.error(TAG, "saveToFile('" + fileName + "', '" + comment + "') - Exception=" + e.toString());
        }
        finally {
            try {
                if (l_bw != null) {
                    l_bw.flush();
                    l_bw.close();
                }
            }
            catch (Exception e) {
                Logger.error(TAG, "saveToFile('" + fileName + "') - Exception closing file=" + e.toString());
            }
        }
    }
}

