/*
 * Decompiled with CFR 0.152.
 */
package moneyview.messages;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import moneyview.Logger;
import moneyview.data.Util;
import moneyview.io.KvmStore;
import moneyview.properties.HMProperties;

public class Messages {
    private static final String TAG = Messages.class.getSimpleName();
    private static KvmStore KVMSTORE;
    public static final String MESSAGES_BASE_FILE_NAME = "messages";
    public static final String[] languages;
    public static final String[] languages_codes;
    public static final String testString = "Messages.testString=\u00e1\u00e9\u00ed\u00e0\u00e8\u00ec\u20acaei\u00e7\u00e7\u00e7\u00e7\u00e7\u00e7\u00e7\u00e7\u00e7";

    public static String[] getReservedKeywords() {
        ArrayList<String> l_al = new ArrayList<String>(Arrays.asList(Messages.getPropertiesAsStringArray("reservedKeyword", "")));
        l_al.add("null");
        l_al.add("[");
        l_al.add("]");
        return l_al.toArray(new String[l_al.size()]);
    }

    public static String[] getDefaultCategories() {
        return Messages.getPropertiesAsStringArray("DefaultCategory", "");
    }

    private static String[] getPropertiesAsStringArray(String baseName, String ext) {
        String l_base = "";
        if (baseName != null) {
            l_base = baseName;
        }
        String l_ext = "";
        if (ext != null) {
            l_ext = ext;
        }
        ArrayList<String> l_al = new ArrayList<String>();
        for (int i = 0; i < 1000; ++i) {
            String l_val = Messages.getString(l_base + i + l_ext);
            if (l_val == null || l_val.startsWith("!") && l_val.endsWith("!")) continue;
            l_al.add(l_val.trim());
        }
        Collections.sort(l_al);
        return l_al.toArray(new String[l_al.size()]);
    }

    private Messages() {
    }

    public static void init() {
        if (HMProperties.getStringProperty("hmy.locale") != null) {
            Messages.init(Util.getLocaleFromString(HMProperties.getStringProperty("hmy.locale")));
            return;
        }
        Messages.getLanguageUserInput();
    }

    public static void getLanguageUserInput() {
        String l_defaultLocale = Util.getDefaultLocale().toString();
        Logger.info(TAG, "init() - default locale=" + l_defaultLocale);
        try {
            KvmStore langKvm = new KvmStore();
            langKvm.loadMessages(Util.getLocaleFromString("fr_FR"));
            JComboBox<String> l_cbLocale = new JComboBox<String>();
            for (int i = 0; i < languages_codes.length; ++i) {
                l_cbLocale.addItem(langKvm.get(languages_codes[i]) + " - " + languages_codes[i]);
                if (!l_defaultLocale.equalsIgnoreCase(languages_codes[i])) continue;
                l_cbLocale.setSelectedIndex(i);
            }
            l_cbLocale.setSize(new Dimension(500, 30));
            l_cbLocale.setPreferredSize(new Dimension(500, 30));
            JFrame l_tmpJF = new JFrame();
            l_tmpJF.setAlwaysOnTop(true);
            JOptionPane.showMessageDialog(l_tmpJF, l_cbLocale, "MoneyView - Please choose language - SVP choisissez votre langue - Pro favor elegir el idioma", 3);
            l_tmpJF.dispose();
            String l_sLocale = (String)l_cbLocale.getSelectedItem();
            if (l_sLocale != null && l_sLocale.length() > 5) {
                String l_locale = l_sLocale.substring(l_sLocale.length() - 5);
                Messages.init(Util.getLocaleFromString(l_locale));
                Messages.saveLocaleSetting(l_locale);
            } else {
                Messages.init(Util.getLocaleFromString("en_GB"));
                Messages.saveLocaleSetting("en_GB");
            }
        }
        catch (Exception e) {
            Messages.init(Util.getLocaleFromString("en_GB"));
            Messages.saveLocaleSetting("en_GB");
        }
    }

    public static void init(Locale locale) {
        Logger.info(TAG, "init(" + locale + ")");
        KVMSTORE = new KvmStore();
        KVMSTORE.loadMessages(locale);
    }

    public static String getString(String key) {
        try {
            String l_s = KVMSTORE.get(key);
            if (l_s == null) {
                return '!' + key + '!';
            }
            return l_s;
        }
        catch (Exception e) {
            Logger.error(TAG, "getString(" + key + ") -> " + e.toString());
            return '!' + key + " - ERROR!";
        }
    }

    public static void saveLocaleSetting(String locale) {
        HMProperties.putProperty("hmy.locale", locale);
        if (locale.endsWith("US")) {
            HMProperties.putProperty("date.day_first", "false");
        } else {
            HMProperties.putProperty("date.day_first", "true");
        }
    }

    static {
        languages = new String[]{"English GB", "English US", "Fran\u00e7ais FR", "Espa\u00f1ol ES"};
        languages_codes = new String[]{"en_GB", "en_US", "fr_FR", "es_ES"};
    }
}

