/*
 * Decompiled with CFR 0.152.
 */
package moneyview.properties;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import moneyview.Logger;
import moneyview.data.ACategory;
import moneyview.data.Account;
import moneyview.io.KvmStore;
import moneyview.messages.Messages;

public class HMProperties {
    private static final String TAG = HMProperties.class.getSimpleName();
    private static KvmStore saveLocationKvm = new KvmStore();
    private static KvmStore stateKvm = new KvmStore();
    private static String saveLocation = null;
    private static String openDirLocation = null;
    public static final String SAVE_LOCATION_KEY = "save.dir_location_";
    public static final String OPEN_DIR_LOCATION_KEY = "open.dir_location";
    public static final String DATE_DAY_FIRST = "date.day_first";
    public static final String FRAME_LEFT = "frame.left";
    public static final String FRAME_TOP = "frame.top";
    public static final String FRAME_WIDTH = "frame.width";
    public static final String FRAME_HEIGHT = "frame.height";
    public static final String FRAME_STATE = "frame.state";
    public static final String FRAME_LOOK_AND_FEEL = "frame.laf";
    public static final String HMY_ACCOUNT_FILES = "hmy.account_files";
    public static final String HMY_CATEGORY_PREFIX = "hmy.category";
    public static final String HMY_LOCALE = "hmy.locale";
    public static final String HMY_VERSION = "hmy.version";
    public static final String HMY_REPORTS_DAYS = "hmy.reports_days";
    public static final String HMY_ENCRYPT_FILES = "hmy.encrypt_files";
    private static final String HMY_PROPERTIES_FILENAME = "moneyview.properties";
    public static final String HMY_SAVE_DIR_LOCATION_FILENAME = "savedir.location";
    public static final String HMY_SAVE_DIR_LOCATION_UTF8_FILENAME = "savelocation-utf8.data";
    private static final String HMY_MAIN_SAVE_DIR_NAME = ".moneyview";
    private static final String HMY_SAVE_DIR_PROPERTIES_COMMENT = "MoneyView properties for save directories";

    public static int getIntProperty(String property) {
        int l_val = 0;
        try {
            l_val = Integer.parseInt(stateKvm.get(property));
        }
        catch (Exception e) {
            Logger.warn(TAG, "getIntProperty: Invalid integer in properties.");
        }
        Logger.verbose(TAG, "getIntProperty: returns " + property + "=" + l_val);
        return l_val;
    }

    public static String getStringProperty(String property) {
        String l_val = null;
        l_val = stateKvm.get(property);
        Logger.verbose(TAG, "getStringProperty: returns " + property + "=" + l_val);
        return l_val;
    }

    public static void putProperty(String key, String val) {
        Logger.verbose(TAG, "putProperty: set " + key + "=" + val);
        stateKvm.put(key, val);
    }

    public static void putProperty(String key, int val) {
        Logger.verbose(TAG, "putProperty: set " + key + "=" + val);
        stateKvm.put(key, "" + val);
    }

    public static void removeProperty(String key) {
        Logger.verbose(TAG, "removeProperty( " + key + ")");
        stateKvm.remove(key);
    }

    private static void putDefaultProperty(String key, String val) {
        if (!stateKvm.getKvm().containsKey(key)) {
            stateKvm.put(key, val);
        }
    }

    private static void putDefaultProperty(String key, int val) {
        if (!stateKvm.getKvm().containsKey(key)) {
            stateKvm.put(key, "" + val);
        }
    }

    public static String getSaveLocation() {
        if (saveLocation != null) {
            return saveLocation;
        }
        String l_stateLocation = HMProperties.getMainSaveDirInUserHome() + File.separator + HMY_SAVE_DIR_LOCATION_FILENAME;
        try {
            saveLocationKvm.loadFile(l_stateLocation);
            saveLocation = saveLocationKvm.get("save.dir_location_0");
            if (saveLocation == null) {
                throw new Exception("Need to init save location");
            }
            openDirLocation = saveLocationKvm.get(OPEN_DIR_LOCATION_KEY);
            if (openDirLocation == null || openDirLocation.length() < 2) {
                openDirLocation = "" + new File(System.getProperty("user.home")).getAbsoluteFile();
                throw new Exception("Need to reset save location key");
            }
        }
        catch (Exception e) {
            Logger.warn(TAG, "getSaveLocation: no properties file found." + e.toString());
            HMProperties.setSaveLocation(null);
        }
        Logger.info(TAG, "getSaveLocation()=" + saveLocation);
        if (HMProperties.saveLocationKvm.wasChangedToUtf8) {
            HMProperties.setSaveLocation(saveLocation);
        }
        return saveLocation;
    }

    public static List<String> getSaveLocationHistory() {
        ArrayList<String> l_res = new ArrayList<String>();
        for (int i = 0; i < 20; ++i) {
            String l_val = saveLocationKvm.get(SAVE_LOCATION_KEY + i);
            if (l_val == null) continue;
            l_res.add(l_val);
        }
        return l_res;
    }

    public static void deleteSaveLocationHistory() {
        String l_currentSaveLocation = HMProperties.getSaveLocation();
        saveLocationKvm.getKvm().clear();
        HMProperties.setSaveLocation(l_currentSaveLocation);
    }

    private static String getMainSaveDirInUserHome() {
        Logger.verbose(TAG, "getMainSaveDirInUserHome()");
        File l_moneyviewHomeDir = new File(System.getProperty("user.home") + File.separator + HMY_MAIN_SAVE_DIR_NAME);
        Logger.verbose(TAG, "getMainSaveDirInUserHome()" + System.getProperty("user.home") + File.separator + HMY_MAIN_SAVE_DIR_NAME);
        Logger.verbose(TAG, "getMainSaveDirInUserHome()" + l_moneyviewHomeDir.getAbsolutePath());
        if (!l_moneyviewHomeDir.exists()) {
            Messages.getLanguageUserInput();
            JOptionPane.showMessageDialog(null, "<html><H2><br><center>" + Messages.getString("HMProperties.1") + File.separator + HMY_MAIN_SAVE_DIR_NAME + "<br>" + Messages.getString("HMProperties.2") + l_moneyviewHomeDir.getAbsolutePath() + "</center><br><br></H2></html>", Messages.getString("HMProperties.0"), 1);
            l_moneyviewHomeDir.mkdir();
        }
        return l_moneyviewHomeDir.getAbsoluteFile().toString();
    }

    public static String getOpenDirLocation() {
        return openDirLocation;
    }

    public static boolean setOpenDirLocation(String dirLocation) {
        try {
            String l_stateLocation = HMProperties.getMainSaveDirInUserHome() + File.separator + HMY_SAVE_DIR_LOCATION_FILENAME;
            openDirLocation = dirLocation;
            saveLocationKvm.put(OPEN_DIR_LOCATION_KEY, openDirLocation);
            saveLocationKvm.saveToFile(l_stateLocation, HMY_SAVE_DIR_PROPERTIES_COMMENT);
            return true;
        }
        catch (Exception e) {
            Logger.error(TAG, "setOpenDirLocation: " + e.toString());
            return false;
        }
    }

    public static boolean setSaveLocation(String dirLocation) {
        if (dirLocation == null) {
            dirLocation = HMProperties.getMainSaveDirInUserHome();
        }
        if (openDirLocation == null || openDirLocation.length() < 2) {
            openDirLocation = "" + new File(System.getProperty("user.home")).getAbsoluteFile();
        }
        String l_stateLocation = HMProperties.getMainSaveDirInUserHome() + File.separator + HMY_SAVE_DIR_LOCATION_FILENAME;
        KvmStore l_nextsaveLocationKvm = new KvmStore();
        try {
            for (int i = 0; i < 19; ++i) {
                String l_val = saveLocationKvm.get(SAVE_LOCATION_KEY + i);
                if (l_val == null || l_val.equals(dirLocation) || l_nextsaveLocationKvm.getKvm().containsValue(l_val)) continue;
                l_nextsaveLocationKvm.put(SAVE_LOCATION_KEY + (i + 1), l_val);
            }
            l_nextsaveLocationKvm.put("save.dir_location_0", dirLocation);
            l_nextsaveLocationKvm.put(OPEN_DIR_LOCATION_KEY, openDirLocation);
            saveLocation = dirLocation;
            saveLocationKvm = l_nextsaveLocationKvm;
            saveLocationKvm.saveToFile(l_stateLocation, HMY_SAVE_DIR_PROPERTIES_COMMENT);
            return true;
        }
        catch (Exception e) {
            Logger.error(TAG, "setSaveLocation: " + e);
            return false;
        }
    }

    private static void setDefaultProperties() {
        HMProperties.putDefaultProperty(FRAME_LEFT, 0);
        HMProperties.putDefaultProperty(FRAME_TOP, 0);
        HMProperties.putDefaultProperty(FRAME_WIDTH, 1280);
        HMProperties.putDefaultProperty(FRAME_HEIGHT, 1024);
        HMProperties.putDefaultProperty(FRAME_STATE, 0);
        HMProperties.putDefaultProperty(DATE_DAY_FIRST, "true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadProperties() {
        boolean l_loadOK;
        block8: {
            Logger.verbose(TAG, "loadProperties()");
            l_loadOK = false;
            try {
                String l_saveDirName = HMProperties.getSaveLocation();
                File l_saveDir = null;
                if (l_saveDirName != null) {
                    l_saveDir = new File(l_saveDirName);
                }
                if (l_saveDir == null || !l_saveDir.exists()) break block8;
                String l_propFilename = l_saveDirName + File.separator + HMY_PROPERTIES_FILENAME;
                try {
                    l_loadOK = stateKvm.loadFile(l_propFilename);
                    if (l_loadOK) {
                        ACategory.restoreFromProperties(stateKvm);
                    }
                }
                catch (Exception e) {
                    Logger.warn(TAG, "loadProperties: no properties file found, Exception=" + e.toString());
                }
            }
            finally {
                if (!l_loadOK) {
                    HMProperties.setDefaultProperties();
                }
            }
        }
        return l_loadOK;
    }

    public static boolean storeProperties() {
        stateKvm.put(HMY_VERSION, "2.4.0");
        String l_hmoneyStateDirStr = HMProperties.getSaveLocation();
        File l_hmoneyStateDir = null;
        if (l_hmoneyStateDirStr != null) {
            l_hmoneyStateDir = new File(l_hmoneyStateDirStr);
        }
        if (l_hmoneyStateDir != null && l_hmoneyStateDir.exists()) {
            ACategory.putCategoriesInProperties(stateKvm);
            String l_propFileName = l_hmoneyStateDir.getAbsoluteFile() + File.separator + HMY_PROPERTIES_FILENAME;
            try {
                stateKvm.saveToFile(l_propFileName, "MoneyView properties file");
                ACategory.setSaved(true);
                return true;
            }
            catch (Exception e) {
                Logger.error(TAG, "storeProperties: " + e);
            }
        }
        return false;
    }

    public static void updateAccountList() {
        String l_al = "";
        for (Account l_a : Account.openAccounts) {
            l_al = l_al + (l_al.length() < 1 ? "" : ",") + l_a.accountName;
        }
        HMProperties.putProperty(HMY_ACCOUNT_FILES, l_al);
        HMProperties.storeProperties();
    }
}

