/*
 * Decompiled with CFR 0.152.
 */
package moneyview.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import moneyview.Logger;

public class ZipMaker {
    private static final String TAG = ZipMaker.class.getSimpleName();
    List<File> fileList = new ArrayList<File>();

    public static void main(String[] args) throws IOException {
        File directoryToZip = new File("C:\\tmp");
        File destZipFile = new File("C:\\tmp.zip");
        ZipMaker l_zm = new ZipMaker();
        l_zm.copyDirectoryToZipFile(directoryToZip, destZipFile);
        System.out.println("done");
    }

    public void copyDirectoryToZipFile(File directoryToZip, File destZipFile) {
        Logger.info(TAG, "copyDirectoryToZipFile( " + directoryToZip + ", " + destZipFile + ")");
        try {
            FileOutputStream fos = new FileOutputStream(destZipFile);
            ZipOutputStream zos = new ZipOutputStream(fos);
            this.getDirectoryFiles(directoryToZip);
            for (File file : this.fileList) {
                if (file.isDirectory() || file.getName().equalsIgnoreCase("savedir.location") || file.equals(destZipFile) || file.getName().startsWith("MoneyView_archive_") && file.getName().endsWith(".zip")) continue;
                this.addToZip(directoryToZip, file, zos);
            }
            zos.close();
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getDirectoryFiles(File dir) {
        try {
            File[] files;
            for (File file : files = dir.listFiles()) {
                this.fileList.add(file);
                if (!file.isDirectory()) continue;
                this.getDirectoryFiles(file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addToZip(File directoryToZip, File file, ZipOutputStream zos) throws Exception {
        int length;
        FileInputStream l_fis = new FileInputStream(file);
        String l_zipFilePath = file.getCanonicalPath().substring(directoryToZip.getCanonicalPath().length() + 1, file.getCanonicalPath().length());
        if (file.isDirectory()) {
            l_zipFilePath = l_zipFilePath + File.separator;
        }
        Logger.debug(TAG, "addToZip(): adding '" + l_zipFilePath + "' to zip file");
        ZipEntry zipEntry = new ZipEntry(l_zipFilePath);
        zipEntry.setTime(file.lastModified());
        zos.putNextEntry(zipEntry);
        byte[] l_buf = new byte[1024];
        while ((length = l_fis.read(l_buf)) >= 0) {
            zos.write(l_buf, 0, length);
        }
        zos.closeEntry();
        l_fis.close();
    }
}

